# Операторы
Арифметические операторы: `+, -, *, /, //, %, **`.
Операторы сравнения: `==, !=, <=, >=, <, >`.
Логические операторы: `not, and, or`.

Обрати внимание: все числа в игре — это числа с плавающей точкой. Все арифметические операторы — это операторы для чисел с плавающей точкой.
`//` определен так, чтобы после деления округлять число в меньшую сторону.

Для использования операторов присваивания нужно разблокировать технологию «Переменные».

## Введение
Операторы позволяют сравнивать, изменять и комбинировать значения.
Арифметические операторы `+, -, *, /, //, %, **` используются для выполнения обычных математических операций над числами.
Операторы сравнения `==, !=, <=, >=, <, >` используются для сравнения значений. Результат всегда либо `True`, либо `False`.
Логические операторы `not, and, or`, также называемые булевыми, используются для комбинирования значений истинности.

## Арифметические операторы
`+` и `-` используются для сложения и вычитания.

`2 + 3` равно `5`.
`3 - 2` равно `1`.

`*`, `/` и `//` используются для умножения и деления.

`2 * 3` равно `6`.
`5 / 2` равно `2.5`.

`//` делает то же самое, что и `/`, но результат округляется в меньшую сторону (до ближайшего целого значения).

`5 // 2` равно `2`.

`%` — это оператор деления по модулю, также известный как оператор получения остатка. По сути, он делит два числа, а затем возвращает остаток. Иначе говоря, он многократно вычитает правое число из левого, пока остаток не станет меньше правого числа.

`4 % 2` равно `0`.
`5 % 2` равно `1`.
`6 % 2` равно `0`
`2 % 6` равно `2`.
`1.5 % 1` равно `0.5`.

`**` — это оператор возведения в степень.

`2**2` равно `4`.
`(-5)**3` равно `-125`.

## Операторы сравнения
`==` и `!=` используются для проверки, являются ли два значения «равными» (`==`) или «неравными» (`!=`). Их можно использовать для всех типов значений.

`2 == 2` равно `True`.
`Entities.Bush != Entities.Bush` равно `False`.
`3 != 3 + 1` равно `True`.

Операторы `<=, >=, <, >` можно использовать только с числами. Они проверяют, является ли число слева «меньшим или равным» (`<=`), «большим или равным» (`>=`), «меньшим» (`<`) или «большим» (`>`), чем число справа.

`1 <= 1` равно `True`.
`2 >= 3` равно`False`.
`-2 < -1` равно `True`.
`6 > 6` равно `False`.

## Логические операторы
`not` просто инвертирует значение:

`not False` равно `True`.
`not True` равно `False`.

`and` равно `True`, только если оба значения `True`.

`True and True` равно `True`.
`True and False` равно `False`.
`False and False` равно `False`.

`or` равно `True`, если хотя бы одно из значений `True`.

`True or True` равно `True`.
`True or False` равно `True`.
`False or False` равно `False`.